﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Art_of_War
{
    public partial class SettingsForm : Form
    {
        LevelEinstellungen level;

        TableLayoutPanel basenTableLayoutPanel;
        Label idLabel;
        Label basengroesseLabel;
        Label typLabel;
        Label einheitenLabel;
        Label spielerzugehoerigkeitLabel;
        Label verbindungenLabel;
        Label positionLabel;
        Panel panelInGroupBox;

        koordinaten spielfeldgroesse;

        public event EventHandler<LevelEventArgs> levelsettingschanged;



        

        public SettingsForm(LevelEinstellungen level)
        {
            InitializeComponent();
           
            this.basenTableLayoutPanel = new TableLayoutPanel();    
            this.basenTableLayoutPanel.Show();
            this.basenTableLayoutPanel.Size = groupBox1.Size;
            //this.basenTableLayoutPanel.AutoSize = true;
            //this.basenTableLayoutPanel.AutoSizeMode = AutoSizeMode.GrowAndShrink;
            this.basenTableLayoutPanel.ColumnCount = 7;
            this.basenTableLayoutPanel.RowCount = 0;
            this.basenTableLayoutPanel.AutoScroll = true;
            //this.basenTableLayoutPanel.AutoSize = true;
            //this.basenTableLayoutPanel.Location = new Point(50, 50);            
            //this.basenTableLayoutPanel.Location = this.groupBox1.Location;
            this.spielfeldBreiteNumeric.Maximum = 2000;
            this.spielfeldHoeheNumeric.Maximum = 2000;                        

            this.groupBox1.Controls.Add(this.basenTableLayoutPanel);
            //this.basenTableLayoutPanel.Anchor = (AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right | AnchorStyles.Top);

            //this.input.KeyPressed += new System.Windows.Forms.KeyEventHandler(input_KeyPressed);


            this.level = new LevelEinstellungen(this);

            #region Benennung der Spalten
            this.idLabel = new Label();
            this.idLabel.Text = "ID";      
            this.basenTableLayoutPanel.Controls.Add(this.idLabel, 0, 0);
            this.basengroesseLabel = new Label();
            this.basengroesseLabel.Text = "Basisgroesse";
            this.basenTableLayoutPanel.Controls.Add(this.basengroesseLabel, 1, 0);
            this.typLabel = new Label();
            this.typLabel.Text = "Basentyp";
            this.basenTableLayoutPanel.Controls.Add(this.typLabel, 2, 0);
            this.einheitenLabel = new Label();
            this.einheitenLabel.Text="Starteinheiten";
            this.basenTableLayoutPanel.Controls.Add(this.einheitenLabel, 3, 0);
            this.spielerzugehoerigkeitLabel = new Label();
            this.spielerzugehoerigkeitLabel.Text="Spieler";
            this.basenTableLayoutPanel.Controls.Add(this.spielerzugehoerigkeitLabel, 4, 0);
            this.verbindungenLabel = new Label();
            this.verbindungenLabel.Text= "Verbindungen";
            this.basenTableLayoutPanel.Controls.Add(this.verbindungenLabel, 5, 0);
            this.positionLabel = new Label();
            this.positionLabel.Text = "Position";
            this.basenTableLayoutPanel.Controls.Add(this.positionLabel, 6, 0);
            #endregion

            #region DefaultLevel laden
            this.spielfeldBreiteNumeric.Value = 850;
            this.spielfeldHoeheNumeric.Value = 850;
            //spielfeldgroesse.x=850;
            //spielfeldgroesse.y=850;
            

            addBase(1, 5, "panzer", 10.0f, zugehoerigkeit.rot, new int[] {3 , 5 }, new koordinaten { x = 0.047f, y = 0.047f },7);
            addBase(2, 5, "panzer", 10.0f, zugehoerigkeit.blau, new int[] { 3, 6 }, new koordinaten { x = 0.93f, y = 0.047f },7);
            addBase(3, 1, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 1, 2 }, new koordinaten { x = 0.4705f, y = 0.047f },7);
            addBase(4, 3, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 5, 6 }, new koordinaten { x = 0.4705f, y = 0.4705f },7);
            addBase(5, 2, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 1, 4, 7 }, new koordinaten { x = 0.1411f, y = 0.5647f },7);
            addBase(6, 2, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 2, 4, 7 }, new koordinaten { x = 0.8470f, y = 0.5647f },7);
            addBase(7, 4, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 5, 6 }, new koordinaten { x = 0.4705f, y = 0.93f },7);


            //level1.AddBasis(new Basis(0, 5, "panzer", 10.0f, zugehoerigkeit.rot, new int[] { 2, 4 }, new koordinaten { x = 0.047f, y = 0.047f }));
            //level1.AddBasis(new Basis(1, 5, "panzer", 10.0f, zugehoerigkeit.blau, new int[] { 2, 5 }, new koordinaten { x = 0.93f, y = 0.047f }));
            //level1.AddBasis(new Basis(2, 1, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 0, 1 }, new koordinaten { x = 0.4705f, y = 0.047f }));
            //level1.AddBasis(new Basis(3, 3, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 4, 5 }, new koordinaten { x = 0.4705f, y = 0.4705f }));
            //level1.AddBasis(new Basis(4, 2, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 0, 3, 6 }, new koordinaten { x = 0.1411f, y = 0.5647f }));
            //level1.AddBasis(new Basis(5, 2, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 1, 3, 6 }, new koordinaten { x = 0.8470f, y = 0.5647f }));
            //level1.AddBasis(new Basis(6, 4, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 4, 5 }, new koordinaten { x = 0.4705f, y = 0.93f }));

            #endregion



        }



        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void okButton_Click(object sender, EventArgs e)
        {

            ////Level auf Werte des TableLayoutPanel ändern
            //this.level = new LevelEinstellungen();
            //for (int i=0; i< basenTableLayoutPanel.RowCount; i++)
            //{

            //    Control basengroesse= basenTableLayoutPanel.GetControlFromPosition(1, i).Controls.;
            //    Control typ= basenTableLayoutPanel.GetControlFromPosition(2, i);
            //    Control einheiten= basenTableLayoutPanel.GetControlFromPosition(3, i);
            //    Control spielerzugehoerigkeit= basenTableLayoutPanel.GetControlFromPosition(4, i);
            //    Control verbindungen= basenTableLayoutPanel.GetControlFromPosition(5, i);
            //    Control position= basenTableLayoutPanel.GetControlFromPosition(6, i);



                
            //    this.level.AddBasis(new Basis(i+1, basengroesse,typ, einheiten, spielerzugehoerigkeit, verbindungen, position);
            //}

            this.level = new LevelEinstellungen();
            this.level.AddBasis(new Basis(0, 5, "panzer", 10.0f, zugehoerigkeit.rot, new int[] { 2 }, new koordinaten { x = 0.47f, y = 0.20f }));
            this.level.AddBasis(new Basis(1, 5, "panzer", 10.0f, zugehoerigkeit.blau, new int[] { 2 }, new koordinaten { x = 0.47f, y = 0.80f }));
            this.level.AddBasis(new Basis(2, 1, "panzer", 0f, zugehoerigkeit.neutral, new int[] { 0, 1 }, new koordinaten { x = 0.75f, y = 0.75f }));




            //Level übergeben an die Form1
            if (levelsettingschanged != null)
            {
                levelsettingschanged (this, new LevelEventArgs(){level=this.level});

            }

            

            //Für alle Basen etc...
            //this.level.AddBasis(new Basis(id, basengroesse, typ, einheiten, spielerzugehoerigkeit, verbindungen, position));



            //if (levelsettingschanged  != null)
            //{
            //    levelsettingschanged(this, new LevelEventArgs() {level=this.level};
            //}

            this.Close();
        }

        private void addBase ()
        {



            int id = basenTableLayoutPanel.RowCount + 1;
            basenTableLayoutPanel.RowCount++;

            #region IDFeldEinstellungen
            //Legt Einstellungen für das IDFeld fest
            Label labelid = new Label();
            labelid.Name = "label" + id;
            labelid.Text = id.ToString();
            labelid.Enabled = false;
            this.basenTableLayoutPanel.Controls.Add(labelid, 0, id);
            #endregion

            #region BasengrößeEinstellungen
            //Legt Einstellungen für das Basengrößefeld fest
            NumericUpDown basesize = new NumericUpDown();
            basesize.Minimum = 1;
            basesize.Maximum = 5;
            basesize.Value = 3;
            this.basenTableLayoutPanel.Controls.Add(basesize, 1, id);
            #endregion

            #region TypFeldEinstellungen
            //Legt Einstellungen für das Typfeld fest
            ComboBox typbox = new ComboBox();
            typbox.Items.Add("panzer");
            typbox.SelectedItem = "panzer";
            this.basenTableLayoutPanel.Controls.Add(typbox, 2, id);
            #endregion

            #region EinheitenFeldEinstellungen
            //Legt Einstellungen für das Einheitenfeld fest
            NumericUpDown einheitenNumeric = new NumericUpDown();
            einheitenNumeric.Minimum = 0;
            einheitenNumeric.Maximum = 500;
            einheitenNumeric.Value = 15;
            this.basenTableLayoutPanel.Controls.Add(einheitenNumeric, 3, id);
            #endregion

            #region ZugehörigkeitsFeldEinstellungen
            //Legt Einstellungen für das Zugehörigkeitsfeld fest
            ComboBox zugehoerigkeitBox = new ComboBox();
            zugehoerigkeitBox.Items.Add(zugehoerigkeit.neutral);
            zugehoerigkeitBox.Items.Add(zugehoerigkeit.rot);
            zugehoerigkeitBox.Items.Add(zugehoerigkeit.blau);
            zugehoerigkeitBox.SelectedItem = zugehoerigkeit.neutral;
            this.basenTableLayoutPanel.Controls.Add(zugehoerigkeitBox, 4, id);
            #endregion

            #region VerbindungsFeldEinstellungen
            //Legt Einstellungen für das Verbindungsfeld fest
            CheckedListBox verbindungsbox = new CheckedListBox();
            verbindungsbox.Name = "verbindungsbox" + id;


            for (int i = 1; i < id; i++)
                verbindungsbox.Items.Add(i);
            this.basenTableLayoutPanel.Controls.Add(verbindungsbox, 5, id);
            #endregion


            #region KoordinatenFeldEinstellungen
            //Legt Einstellungen für das Koordinatenfeld fest

            TableLayoutPanel koordinatenPanel = new TableLayoutPanel();
            koordinatenPanel.RowCount = 2;
            koordinatenPanel.ColumnCount = 2;



            Label posxlabel = new Label();
            posxlabel.Text = "X-Position:";
            koordinatenPanel.Controls.Add(posxlabel, 0, 0);
            //this.basenTableLayoutPanel.Controls.Add(posxlabel, 6, id);


            NumericUpDown posxNumeric = new NumericUpDown();
            posxNumeric.Maximum = this.spielfeldBreiteNumeric.Value;
            posxNumeric.Minimum = 0;
            posxNumeric.Value = 5;
            koordinatenPanel.Controls.Add(posxNumeric, 1, 0);
            //this.basenTableLayoutPanel.Controls.Add(posxNumeric, 6, id);

            Label posylabel = new Label();
            posylabel.Text = "Y-Position";
            koordinatenPanel.Controls.Add(posylabel, 0, 1);
            //this.basenTableLayoutPanel.Controls.Add(posylabel, 6, id);

            NumericUpDown posyNumeric = new NumericUpDown();
            posxNumeric.Maximum = this.spielfeldBreiteNumeric.Value;
            posxNumeric.Minimum = 0;
            posyNumeric.Value = 5;
            koordinatenPanel.Controls.Add(posyNumeric, 1, 1);
            //this.basenTableLayoutPanel.Controls.Add(posyNumeric, 6, id);

            this.basenTableLayoutPanel.Controls.Add(koordinatenPanel, 6, id);


            #endregion



        }

        private void addBase(int id, int basengroesse, string typ, float einheiten, zugehoerigkeit spielerzugehoerigkeit, int[] verbindungen, koordinaten position, int gesamtbasen)
        {
            this.basenTableLayoutPanel.RowCount++;
            //this.level.AddBasis(new Basis(id, basengroesse, typ, einheiten, spielerzugehoerigkeit, verbindungen, position));

            #region IDFeldEinstellungen
            //Legt Einstellungen für das IDFeld fest
            Label labelid = new Label();
            labelid.Name = "label"+id;
            labelid.Text= id.ToString();
            labelid.Enabled=false;
            this.basenTableLayoutPanel.Controls.Add(labelid, 0, id);
            #endregion

            #region BasengrößeEinstellungen
            //Legt Einstellungen für das Basengrößefeld fest
            NumericUpDown basesize = new NumericUpDown();
            basesize.Minimum = 1;
            basesize.Maximum = 5;
            basesize.Value = basengroesse;
            this.basenTableLayoutPanel.Controls.Add(basesize, 1, id);
            #endregion

            #region TypFeldEinstellungen
            //Legt Einstellungen für das Typfeld fest
            ComboBox typbox = new ComboBox();
            typbox.Items.Add(typ);
            typbox.SelectedItem = typ;
            this.basenTableLayoutPanel.Controls.Add(typbox, 2, id);
            #endregion

            #region EinheitenFeldEinstellungen
            //Legt Einstellungen für das Einheitenfeld fest
            NumericUpDown einheitenNumeric = new NumericUpDown();
            einheitenNumeric.Minimum = 0;
            einheitenNumeric.Maximum = 500;
            einheitenNumeric.Value = (decimal)einheiten;
            this.basenTableLayoutPanel.Controls.Add(einheitenNumeric, 3, id);
            #endregion

            #region ZugehörigkeitsFeldEinstellungen
            //Legt Einstellungen für das Zugehörigkeitsfeld fest
            ComboBox zugehoerigkeitBox = new ComboBox();
            zugehoerigkeitBox.Items.Add(zugehoerigkeit.neutral);
            zugehoerigkeitBox.Items.Add(zugehoerigkeit.rot);
            zugehoerigkeitBox.Items.Add(zugehoerigkeit.blau);
            zugehoerigkeitBox.SelectedItem = spielerzugehoerigkeit;
            this.basenTableLayoutPanel.Controls.Add(zugehoerigkeitBox, 4, id);
            #endregion

            #region VerbindungsFeldEinstellungen
            //Legt Einstellungen für das Verbindungsfeld fest
            CheckedListBox verbindungsbox = new CheckedListBox();
            verbindungsbox.Name = "verbindungsbox" + id;


            for (int i = 0; i < gesamtbasen; i++)
            {
                verbindungsbox.Items.Add(i + 1);
            }

            for (int i = 0; i < verbindungen.Length; i++)
                verbindungsbox.SetItemChecked(verbindungen[i]-1, true);
            
            this.basenTableLayoutPanel.Controls.Add(verbindungsbox, 5, id);
            #endregion


            #region KoordinatenFeldEinstellungen
            //Legt Einstellungen für das Koordinatenfeld fest

            TableLayoutPanel koordinatenPanel = new TableLayoutPanel();
            koordinatenPanel.RowCount = 2;
            koordinatenPanel.ColumnCount = 2;

            

            Label posxlabel = new Label();
            posxlabel.Text = "X-Position:";
            koordinatenPanel.Controls.Add(posxlabel,0,0);
            //this.basenTableLayoutPanel.Controls.Add(posxlabel, 6, id);


            NumericUpDown posxNumeric = new NumericUpDown();
            posxNumeric.Maximum= this.spielfeldBreiteNumeric.Value;
            posxNumeric.Minimum=0;
            posxNumeric.Value= (decimal)position.x;
            koordinatenPanel.Controls.Add(posxNumeric,1,0);
            //this.basenTableLayoutPanel.Controls.Add(posxNumeric, 6, id);

            Label posylabel = new Label();
            posylabel.Text = "Y-Position";
            koordinatenPanel.Controls.Add(posylabel,0,1);
            //this.basenTableLayoutPanel.Controls.Add(posylabel, 6, id);

            NumericUpDown posyNumeric = new NumericUpDown();
            posxNumeric.Maximum = this.spielfeldBreiteNumeric.Value;
            posxNumeric.Minimum = 0;
            posyNumeric.Value = (decimal)position.y;
            koordinatenPanel.Controls.Add(posyNumeric,1,1);
            //this.basenTableLayoutPanel.Controls.Add(posyNumeric, 6, id);

            this.basenTableLayoutPanel.Controls.Add(koordinatenPanel, 6, id);

            #endregion

        }

        private void deleteBase()
        {
            if (basenTableLayoutPanel.RowCount > 0)
            {

                for (int i = 0; i < basenTableLayoutPanel.ColumnCount; i++)
                {
                    basenTableLayoutPanel.Controls.Remove(basenTableLayoutPanel.GetControlFromPosition(i, basenTableLayoutPanel.RowCount));
                }


                this.basenTableLayoutPanel.RowCount--;
            }
        }

        private void addBaseButton_Click(object sender, EventArgs e)
        {
            addBase();
        }

        private void removeBaseButton_Click(object sender, EventArgs e)
        {
            deleteBase();
        }


    }
}